## Framework Version 5

See the [Versioning README](README.md) for more details on framework versions in general.

#### Breaking Changes

- Earlier framework versions provided `getProjectSettings()` and `setProjectSettings()` methods which each were broken. The first returned copies of system-only values as if they were project values, and the second simply did not work (it did nothing). Both have been fixed in this framework version. `getProjectSettings()` now returns project settings **only**, in a format that is different from earlier framework versions (`key => value` instead of `key => ('value' => value, 'system_value' => systemvalue)`).
- Calls to `$module->getSubSettings()` now use the new implementation that has been available via `$module->framework->getSubSettings()` since v2.  You can continue using the old implementation by calling `$module->getSubSettings_v1()` instead.  However, it may be prudent to implement a way to copy your sub-settings over to a new setting key using the new implementation to avoid issues with the old one.  The specifics for migrating sub-settings cannot be automated because they are technically ambiguous and specific to the way settings are defined and used in each module.
- If skipping framework versions, do not forget to review/address the breaking changes from all prior framework versions.

#### New Features

- Modules may now omit `->framework` syntax for all module method calls.  For example, `$module->getRecordIdField()` may now be used in place of `$module->framework->getRecordIdField()`.
